<?php
/**
 * Shortcode attributes
 * @var $atts
 * @var $social_networks
 * @var $social_shape
 * @var $social_size
 * @var $css_animation
 * @var $animation_duration
 * @var $animation_delay
 * @var $el_class
 * @var $social_text
 * @var $css
 * @var $responsive
 * Shortcode class
 * @var $this WPBakeryShortCode_GSF_Social_Networks
 */

$social_networks = $social_shape = $social_size = $css_animation = $animation_duration = $animation_delay = $el_class = $css = $responsive = '';
if(!function_exists( 'Spring_Plant' )) return;
$atts = vc_map_get_attributes($this->getShortcode(), $atts);
extract($atts);

$wrapper_classes = array(
	'gf-social-networks',
	G5P()->core()->vc()->customize()->getExtraClass($el_class),
	$this->getCSSAnimation($css_animation),
	vc_shortcode_custom_css_class( $css ),
	$responsive
);

if ('' !== $css_animation && 'none' !== $css_animation) {
	$animation_class = G5P()->core()->vc()->customize()->get_animation_class($animation_duration, $animation_delay);
	$wrapper_classes[] = $animation_class;
}

$class_to_filter = implode(' ', array_filter($wrapper_classes));
$css_class = apply_filters(VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts);

?>
<div class="<?php echo esc_attr($css_class) ?>">
    <?php Spring_Plant()->templates()->social_networks(explode( ',', $social_networks ), $social_shape, $social_size, $social_text);?>
</div>