<?php
/**
 * The template for displaying comments.php
 *
 * @package WordPress
 * @subpackage spring
 * @since spring 1.0
 */
if (post_password_required()) {
	return;
}
?>
<div id="comments" class="gf-comments-area clearfix">
    <?php if (have_comments()) : ?>
        <div class="comments-list clearfix">
            <h4 class="gf-heading-title"><span><?php comments_number(esc_html__('No Comments', 'spring-plant'), esc_html__('One Comment', 'spring-plant'), esc_html__('Comments (%)', 'spring-plant'), '') ?></span></h4>
            <ol class="comment-list clearfix">
                <?php wp_list_comments(Spring_Plant()->blog()->get_list_comments_args()); ?>
            </ol>
            <?php if (get_comment_pages_count() > 1): ?>
                <nav class="comment-navigation blog-pagination clearfix mg-top-20">
                    <?php $paginate_comments_args = array(
                        'prev_text' => wp_kses_post(__('<i class="fa fa-angle-left"></i>','spring-plant')) ,
                        'next_text' => wp_kses_post(__('<i class="fa fa-angle-right"></i>','spring-plant')),
                    );
                    paginate_comments_links($paginate_comments_args);
                    ?>
                </nav>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php comment_form(Spring_Plant()->blog()->get_comments_form_args()); ?>
</div>
